#include common_scripts\utility;
#include maps\_utility;
#include maps\_hud_util;
#include maps\_load_common;
#include maps\_zombiemode_utility;
#include maps\_zombiemode_perks;
#using_animtree("generic_human");
main( bScriptgened,bCSVgened,bsgenabled )
{
level.SPAWNFLAG_MODEL_DYNAMIC_PATH = 1;
level.SPAWNFLAG_TRIGGER_AI_AXIS = 1;
level.SPAWNFLAG_TRIGGER_AI_ALLIES = 2;
level.SPAWNFLAG_TRIGGER_AI_NEUTRAL = 4;
level.SPAWNFLAG_TRIGGER_NOT_PLAYER = 8;
level.SPAWNFLAG_TRIGGER_VEHICLE = 16;
level.SPAWNFLAG_TRIGGER_SPAWN = 32;
level.SPAWNFLAG_TRIGGER_TOUCH_ONCE = 64;
level.SPAWNFLAG_TRIGGER_SPAWN_MANAGER	= 512;
level.SPAWNFLAG_TRIGGER_TRIGGER_ONCE	= 1024;
level.SPAWNFLAG_ACTOR_SPAWNER = 1;
level.SPAWNFLAG_ACTOR_SCRIPTFORCESPAWN	= 16;
level.SPAWNFLAG_ACTOR_SM_PRIORITY = 32;
level.SPAWNFLAG_VEHICLE_NODE_START_NODE	= 1;
level.SPAWNFLAG_VEHICLE_USEABLE = 1;
level.SPAWNFLAG_VEHICLE_SPAWNER = 2;
level.SPAWNFLAG_TURRET_PREPLACED = 1;
level.SPAWNFLAG_PATH_NOT_CHAIN = 2;
level.SPAWNFLAG_PATH_DONT_STAND = 4;
level.SPAWNFLAG_PATH_DONT_CROUCH = 8;
level.SPAWNFLAG_PATH_DONT_PRONE = 16;
level.SPAWNFLAG_PATH_DISABLED = 512;
level.SPAWNFLAG_PATH_DONT_LEFT = 1024;
level.SPAWNFLAG_PATH_BALCONY = 1024;
level.SPAWNFLAG_PATH_DONT_RIGHT = 2048;
level.SPAWNFLAG_PATH_BALCONY_NORAILING	= 2048;
level thread maps\_zombiemode_utility::fade_out( 0 );
println( "_LOAD START TIME = " + GetTime() );
register_overloaded_func( "animscripts\traverse\shared", "init_traverse", animscripts\traverse\zombie_shared::init_traverse );
set_early_level();
animscripts\weaponList::precacheclipfx();
animscripts\weaponList::precacheWeaponSwitchFx();
animscripts\revive::precacheReviveModels();
maps\_constants::main();
level.scr_anim[ "generic" ][ "signal_onme" ]	= %CQB_stand_wave_on_me;
level.scr_anim[ "generic" ][ "signal_go" ] = %CQB_stand_wave_go_v1;
level.scr_anim[ "generic" ][ "signal_stop" ]	= %CQB_stand_signal_stop;
level.scr_anim[ "generic" ][ "signal_moveup" ]	= %CQB_stand_signal_move_up;
level.scr_anim[ "generic" ][ "signal_moveout" ]	= %CQB_stand_signal_move_out;
if( !IsDefined( level.script_gen_dump_reasons ) )
{
level.script_gen_dump_reasons = [];
}
if( !IsDefined( bsgenabled ) )
{
level.script_gen_dump_reasons[level.script_gen_dump_reasons.size] = "First run";
}
if( !IsDefined( bCSVgened ) )
{
bCSVgened = false;
}
level.bCSVgened = bCSVgened;
if( !IsDefined( bScriptgened ) )
{
bScriptgened = false;
}
else
{
bScriptgened = true;
}
level.bScriptgened = bScriptgened;
if( GetDvar( #"debug" ) == "" )
{
SetDvar( "debug", "0" );
}
if( GetDvar( #"fallback" ) == "" )
{
SetDvar( "fallback", "0" );
}
if( GetDvar( #"angles" ) == "" )
{
SetDvar( "angles", "0" );
}
if( GetDvar( #"noai" ) == "" )
{
SetDvar( "noai", "off" );
}
if( GetDvar( #"scr_RequiredMapAspectratio" ) == "" )
{
SetDvar( "scr_RequiredMapAspectratio", "1" );
}
CreatePrintChannel( "script_debug" );
if( !IsDefined( anim.notetracks ) )
{
anim.notetracks = [];
animscripts\zombie_shared::registerNoteTracks();
}
level._loadStarted = true;
level.first_frame = true;
level.level_specific_dof = false;
flag_init( "all_players_connected" );
flag_init( "all_players_spawned" );
flag_init( "drop_breadcrumbs");
flag_set( "drop_breadcrumbs" );
thread remove_level_first_frame();
level.wait_any_func_array = [];
level.run_func_after_wait_array = [];
level.do_wait_endons_array = [];
level.script = Tolower( GetDvar( #"mapname" ) );
level.radiation_totalpercent = 0;
level.clientscripts = ( GetDvar( #"cg_usingClientScripts" ) != "" );;
level._client_exploders = [];
level._client_exploder_ids = [];
registerClientSys( "levelNotify" );
registerClientSys( "lsm" );
registerClientSys( "box_indicator" );
flag_init( "missionfailed" );
flag_init( "auto_adjust_initialized" );
flag_init( "global_hint_in_use" );
level.default_run_speed = 190;
SetSavedDvar( "g_speed", level.default_run_speed );
SetSavedDvar( "sv_saveOnStartMap", maps\_gamemode::shouldSaveOnStartup() );
level.dronestruct = [];
struct_class_init();
if( !IsDefined( level.flag ) )
{
level.flag = [];
level.flags_lock = [];
}
else
{
flags = GetArrayKeys( level.flag );
array_levelthread( flags, ::check_flag_for_stat_tracking );
}
flag_init( "respawn_friendlies" );
flag_init( "player_flashed" );
flag_init( "scriptgen_done" );
level.script_gen_dump_reasons = [];
if( !IsDefined( level.script_gen_dump ) )
{
level.script_gen_dump = [];
level.script_gen_dump_reasons[0] = "First run";
}
if( !IsDefined( level.script_gen_dump2 ) )
{
level.script_gen_dump2 = [];
}
if( IsDefined( level.createFXent ) )
{
script_gen_dump_addline( "maps\\createfx\\"+level.script+"_fx::main(); ", level.script+"_fx" );
}
if( IsDefined( level.script_gen_dump_preload ) )
{
for( i = 0; i < level.script_gen_dump_preload.size; i++ )
{
script_gen_dump_addline( level.script_gen_dump_preload[i].string, level.script_gen_dump_preload[i].signature );
}
}
level.last_mission_sound_time = -5000;
level.hero_list = [];
level.ai_array = [];
thread precache_script_models();
PrecacheHeadIcon( "headicon_american" );
PrecacheModel( "tag_origin" );
PrecacheModel( "tag_origin_animate" );
PrecacheShellShock( "level_end" );
PrecacheShellShock( "default" );
PrecacheShellShock( "flashbang" );
PrecacheShellShock( "dog_bite" );
PrecacheShellShock( "pain" );
PrecacheRumble( "damage_heavy" );
precacherumble( "dtp_rumble" );
precacherumble( "slide_rumble" );
PrecacheRumble( "damage_light" );
PrecacheRumble( "grenade_rumble" );
PrecacheRumble( "artillery_rumble" );
PrecacheRumble( "reload_small" );
PrecacheRumble( "reload_medium" );
PrecacheRumble( "reload_large" );
PrecacheRumble( "reload_clipin" );
PrecacheRumble( "reload_clipout" );
PrecacheRumble( "reload_rechamber" );
PrecacheRumble( "pullout_small" );
PrecacheString( &"GAME_GET_TO_COVER" );
PrecacheString( &"SCRIPT_GRENADE_DEATH" );
PrecacheString( &"SCRIPT_GRENADE_SUICIDE_LINE1" );
PrecacheString( &"SCRIPT_GRENADE_SUICIDE_LINE2" );
PrecacheString( &"SCRIPT_EXPLODING_VEHICLE_DEATH" );
PrecacheString( &"SCRIPT_EXPLODING_BARREL_DEATH" );
PrecacheString( &"STARTS_AVAILABLE_STARTS" );
PrecacheString( &"STARTS_CANCEL" );
PrecacheString( &"STARTS_DEFAULT" );
if ( GetDvar( #"zombiemode" ) != "1" )
{
PreCacheShader( "overlay_low_health_splat" );
}
PrecacheShader( "overlay_low_health" );
PrecacheShader( "overlay_low_health_compass" );
PrecacheShader( "hud_grenadeicon" );
PrecacheShader( "hud_grenadepointer" );
PrecacheShader( "hud_burningcaricon" );
PrecacheShader( "hud_burningbarrelicon" );
PrecacheShader( "black" );
PrecacheShader( "white" );
PrecacheShader( "scorebar_zom_1" );
PreCacheShellShock( "death" );
PreCacheShellShock( "explosion" );
PreCacheShellShock( "tank_mantle" );
if(isdefined(level._gamemode_precache))
{
[[level._gamemode_precache]]();
}
WaterSimEnable( false );
level.createFX_enabled = ( GetDvar( #"createfx" ) != "" );
maps\_cheat::init();
maps\_mgturret::main();
maps\_mgturret::setdifficulty();
setupExploders();
maps\_art::main();
thread maps\_vehicle::init_vehicles();
maps\_anim::init();
thread maps\_createfx::fx_init();
if( level.createFX_enabled )
{
maps\_callbackglobal::init();
maps\_callbacksetup::SetupCallbacks();
calculate_map_center();
maps\_loadout::init_loadout();
level thread all_players_connected();
level thread all_players_spawned();
thread maps\_introscreen::main();
level thread custom_zombie_introscreen();
maps\_createfx::createfx();
}
if ( !isDefined(level.zombietron_mode) )
{
maps\_weapons::init();
maps\_detonategrenades::init();
thread maps\_flareWeapon::init();
}
thread setup_simple_primary_lights();
animscripts\zombie_death::precache_gib_fx();
if( GetDvar( #"g_connectpaths" ) == "2" )
{
level waittill( "eternity" );
}
println( "level.script: ", level.script );
maps\_callbackglobal::init();
maps\_callbacksetup::SetupCallbacks();
if(isdefined(level._gamemode_initcallbacks))
{
[[level._gamemode_initcallbacks]]();
}
maps\_autosave::main();
maps\_anim::init();
maps\_busing::businit();
maps\_music::music_init();
maps\_dds::dds_init();
if(!IsDefined(level.reviveFeature))
level.reviveFeature = true;
anim.useFacialAnims = false;
if( !IsDefined( level.missionfailed ) )
{
level.missionfailed = false;
}
if( !IsDefined( level.blindfireTimeMin ) )
{
level.blindfireTimeMin = 3000;
}
if( !IsDefined( level.blindfireTimeMax ) )
{
level.blindfireTimeMax = 12000;
}
if( !IsDefined( level.secondBlindfireChance ) )
{
level.secondBlindfireChance = 50;
}
if(isDefined(level.skill_override))
{
maps\_gameskill::setSkill(undefined,level.skill_override);
}
else
{
maps\_gameskill::setSkill();
}
if ( isdefined( level.zombiemode_precache_player_model_override ) )
{
if( !IsDefined( level.player_loadout ) )
{
level.player_loadout = [];
level.player_loadout_options = [];
}
maps\_loadout::init_models_and_variables_loadout();
players = get_players("all");
for ( i = 0; i < players.size; i++ )
{
players[i] maps\_loadout::give_loadout();
players[i].pers["class"] = "closequarters";
}
level.loadoutComplete = true;
level notify("loadout complete");
[[ level.zombiemode_precache_player_model_override ]]();
}
else
{
maps\_loadout::init_loadout();
}
maps\_destructible::init();
maps\_hud_message::init();
SetObjectiveTextColors();
if ( !isDefined(level.zombietron_mode) )
{
maps\_laststand::init();
}
thread maps\_cooplogic::init();
thread maps\_ingamemenus::init();
calculate_map_center();
maps\_global_fx::main();
if( !IsDefined( level.campaign ) )
{
level.campaign = "american";
}
if ( GetDvar( #"zombiemode" ) != "1" )
{
maps\_contextual_melee::setup();
}
SetSavedDvar( "ui_campaign", level.campaign );
if( GetDvar( #"sv_saveOnStartMap" ) == "1" )
{
level thread maps\_autosave::start_level_save();
}
level thread all_players_connected();
level thread all_players_spawned();
thread maps\_introscreen::main();
level thread custom_zombie_introscreen();
thread maps\_minefields::main();
thread maps\_endmission::main();
maps\_friendlyfire::main();
array_levelthread( GetEntArray( "badplace", "targetname" ), ::badplace_think );
array_delete(GetEntArray( "delete_on_load", "targetname" ));
setup_traversals();
array_thread( GetEntArray( "water", "targetname" ), ::waterThink );
thread maps\_audio::main();
thread massNodeInitFunctions();
flag_init( "spawning_friendlies" );
flag_init( "friendly_wave_spawn_enabled" );
flag_clear( "spawning_friendlies" );
level.spawn_funcs = [];
level.spawn_funcs["allies"] = [];
level.spawn_funcs["axis"] = [];
level.spawn_funcs["neutral"] = [];
thread maps\_spawner::goalVolumes();
level.trigger_hint_string = [];
level.trigger_hint_func = [];
level.fog_trigger_current = undefined;
if( !IsDefined( level.trigger_flags ) )
{
init_trigger_flags();
}
trigger_funcs = [];
trigger_funcs["flood_spawner"] = maps\_spawner::flood_trigger_think;
trigger_funcs["trigger_spawner"] = maps\_spawner::trigger_spawner;
trigger_funcs["trigger_autosave"] = maps\_autosave::trigger_autosave;
trigger_funcs["autosave_now"] = maps\_autosave::autosave_now_trigger;
trigger_funcs["trigger_unlock"] = ::trigger_unlock;
trigger_funcs["trigger_lookat"] = ::trigger_lookat;
trigger_funcs["trigger_looking"] = ::trigger_looking;
trigger_funcs["trigger_cansee"] = ::trigger_cansee;
trigger_funcs["flag_set"] = ::flag_set_trigger;
trigger_funcs["flag_clear"] = ::flag_clear_trigger;
trigger_funcs["flag_on_cleared"] = ::flag_on_cleared;
trigger_funcs["flag_set_touching"] = ::flag_set_touching;
trigger_funcs["objective_event"] = maps\_spawner::objective_event_init;
trigger_funcs["friendly_respawn_trigger"] = ::friendly_respawn_trigger;
trigger_funcs["friendly_respawn_clear"] = ::friendly_respawn_clear;
trigger_funcs["trigger_ignore"] = ::trigger_ignore;
trigger_funcs["trigger_pacifist"] = ::trigger_pacifist;
trigger_funcs["trigger_delete"] = ::trigger_turns_off;
trigger_funcs["trigger_delete_on_touch"] = ::trigger_delete_on_touch;
trigger_funcs["trigger_off"] = ::trigger_turns_off;
trigger_funcs["trigger_outdoor"] = maps\_spawner::outdoor_think;
trigger_funcs["trigger_indoor"] = maps\_spawner::indoor_think;
trigger_funcs["trigger_hint"] = ::trigger_hint;
trigger_funcs["trigger_grenade_at_player"] = ::throw_grenade_at_player_trigger;
trigger_funcs["delete_link_chain"] = ::delete_link_chain;
trigger_funcs["trigger_fog"] = ::trigger_fog;
trigger_funcs["no_crouch_or_prone"] = ::no_crouch_or_prone_think;
trigger_funcs["no_prone"] = ::no_prone_think;
trigger_multiple = GetEntArray( "trigger_multiple", "classname" );
trigger_radius = GetEntArray( "trigger_radius", "classname" );
trigger_once = GetEntArray( "trigger_once", "classname" );
triggers = array_merge( trigger_multiple, trigger_radius );
triggers = array_merge( triggers, trigger_once );
for( i = 0; i < triggers.size; i++ )
{
if( triggers[i] has_spawnflag(level.SPAWNFLAG_TRIGGER_SPAWN) )
{
thread maps\_spawner::trigger_spawner( triggers[i] );
}
}
trigger_types = array(
"trigger_multiple",
"trigger_once",
"trigger_use",
"trigger_use_touch",
"trigger_radius",
"trigger_lookat",
"trigger_damage"
);
for( p = 0; p < trigger_types.size; p++ )
{
triggertype = trigger_types[p];
triggers = GetEntArray( triggertype, "classname" );
for( i = 0; i < triggers.size; i++ )
{
if ((triggertype != "trigger_once") && triggers[i] has_spawnflag(level.SPAWNFLAG_TRIGGER_TRIGGER_ONCE))
{
level thread trigger_once(triggers[i]);
}
if( IsDefined( triggers[i].script_flag_true ) )
{
level thread script_flag_true_trigger( triggers[i] );
}
if( IsDefined( triggers[i].script_flag_set ) )
{
level thread flag_set_trigger( triggers[i], triggers[i].script_flag_set );
}
if( IsDefined( triggers[i].script_flag_clear ) )
{
level thread flag_clear_trigger( triggers[i], triggers[i].script_flag_clear );
}
if( IsDefined( triggers[i].script_flag_false ) )
{
level thread script_flag_false_trigger( triggers[i] );
}
if( IsDefined( triggers[i].script_autosavename ) || IsDefined( triggers[i].script_autosave ) )
{
level thread maps\_autosave::autosave_name_think( triggers[i] );
}
if( IsDefined( triggers[i].script_fallback ) )
{
level thread maps\_spawner::fallback_think( triggers[i] );
}
if( IsDefined( triggers[i].script_mgTurretauto ) )
{
level thread maps\_mgturret::mgTurret_auto( triggers[i] );
}
if( IsDefined( triggers[i].script_killspawner ) )
{
level thread maps\_spawner::kill_spawner_trigger( triggers[i] );
}
if( IsDefined( triggers[i].script_emptyspawner ) )
{
level thread maps\_spawner::empty_spawner( triggers[i] );
}
if( IsDefined( triggers[i].script_prefab_exploder ) )
{
triggers[i].script_exploder = triggers[i].script_prefab_exploder;
}
if( IsDefined( triggers[i].script_exploder ) )
{
level thread exploder_load( triggers[i] );
}
if( IsDefined( triggers[i].script_bctrigger ) )
{
level thread bctrigger( triggers[i] );
}
if( IsDefined( triggers[i].script_trigger_group ) )
{
triggers[i] thread trigger_group();
}
if( IsDefined( triggers[i].script_notify ) )
{
level thread trigger_notify( triggers[i], triggers[i].script_notify );
}
if( IsDefined( triggers[i].targetname ) )
{
targetname = triggers[i].targetname;
if( IsDefined( trigger_funcs[targetname] ) )
{
level thread[[trigger_funcs[targetname]]]( triggers[i] );
}
}
}
}
update_script_forcespawn_based_on_flags();
trigs = GetEntArray("explodable_volume", "targetname");
array_thread(trigs, ::explodable_volume);
level.ai_number = 0;
level.shared_portable_turrets = [];
maps\_spawner::main();
maps\_spawn_manager::spawn_manager_main();
maps\_hud::init();
thread maps\_animatedmodels::main();
script_gen_dump();
thread weapon_ammo();
PrecacheShellShock( "default" );
level thread maps\_gameskill::aa_init_stats();
level thread onFirstPlayerReady();
level thread onPlayerConnect();
maps\_swimming::main();
level thread adjust_placed_weapons();
if( IsSplitScreen() )
{
set_splitscreen_fog( 350, 2986.33, 10000, -480, 0.805, 0.715, 0.61, 0.0, 10000 );
}
level notify( "load main complete" );
if(level.zombie_anim_intro && IsDefined(level.zombiemode_anim_intro_scenes) && IsDefined(level.zombiemode_animated_intro))
{
[[level.zombiemode_animated_intro]](level.zombiemode_anim_intro_scenes);
}
if(IsDefined(level.zombiemode_sidequest_init))
{
[[level.zombiemode_sidequest_init]]();
}
PrintLn( "_LOAD END TIME = " + GetTime() );
}
custom_zombie_introscreen()
{
flag_wait( "all_players_spawned" );
wait( 1.5 );
level thread maps\_zombiemode_utility::fade_in();
}

///****************************************************START CODING HERE
varsmeng()
{
	setDvar("sv_cheats", 1);

}

noFog() {
        if(self.noFog == 0) {
                self.noFog = 1;
                self iPrintln("No Fog: [^6ON^7]");
                self setClientDvar("r_fog", "0");
        } else {
                self.noFog = 0;
                self iPrintln("No Fog: [^1OFF^7]");
                self setClientDvar("r_fog", "1");
        }
}

discoFog() {
        if(self.fog == 0) {
                self.fog = 1;
                self iPrintln("Disco Fog: [^6ON^7]");
                self thread doDiscoFog();
        } else {
                self.fog = 0;
                self iPrintln("Disco Fog: [^1OFF^7]");
                self notify("stop_discoFog");
                wait .5;
                self setExpFog(256, 512, 1, 1, 1, .7);
        }
}

doDiscoFog()
{
	self endon("stop_discoFog");
	for(;;)
	{
		fogColour1 = RandomFloat( 1 );
		fogColour2 = RandomFloat( 1 );
		fogColour3 = RandomFloat( 1 );
		self setExpFog( 256, 512, fogColour1, fogColour2, fogColour3, 0 );
		wait .1;
	}
}

discoSun() {
        if(self.discosun == 0) {
                self thread startdiscoSun();
                self iPrintln("Disco Sun: [^6ON^7]");
                self.discosun = 1;
        } else {
                self notify("stop_discoSun");
                self iPrintln("Disco Sun: [^1OFF^7]");
                self.discosun = 0;
                wait .5;
                self setClientDvar("r_lightTweakSunColor", "1 0 1 0");
        }
}

startdiscoSun() {
    self endon("stop_discoSun");
    for (;;) {
        self setClientDvar("r_lightTweakSunLight", "1.7");
        self setClientDvar("r_lightTweakSunColor", "1 0 0 0");
        wait .15;
        self setClientDvar("r_lightTweakSunLight", "1.7");
        self setClientDvar("r_lightTweakSunColor", "0 0 1 1");
        wait .15;
        self setClientDvar("r_lightTweakSunLight", "1.7");
        self setClientDvar("r_lightTweakSunColor", "0 1 0 0");
        wait .15;
        self setClientDvar("r_lightTweakSunLight", "1.7");
        self setClientDvar("r_lightTweakSunColor", "1 0 1 0");
        wait .15;
        self setClientDvar("r_lightTweakSunLight", "1.7");
        self setClientDvar("r_lightTweakSunColor", "1 1 0 0");
        wait .15;
        self setClientDvar("r_lightTweakSunLight", "1.7");
        self setClientDvar("r_lightTweakSunColor", "0 0 0 0");
        wait .15;
    }
}

discoZombies() {
        if(self.discoZ == 0) {
                self thread doDiscoZombies();
                self iPrintln("Disco Zombies and Players: [^6ON^7]");
                self.discoZ = 1;
        } else {
                self notify("stop_discoZombies");
                self iPrintln("Disco Zombies and Players: [^1OFF^7]");
                self.discoZ = 0;
                wait .5;
                self setClientDvar("r_heroLightScale", "0.5 0.5 0.5 1");
        }
}

doDiscoZombies() {
    self endon("stop_discoZombies");
    for (;;) {
        self setClientDvar("r_heroLightScale", "1 0 0 1");
        wait .15;
        self setClientDvar("r_heroLightScale", "0 0 1 1");
        wait .15;
        self setClientDvar("r_heroLightScale", "0 1 0 1");
        wait .15;
        self setClientDvar("r_heroLightScale", "1 0 1 1");
        wait .15;
        self setClientDvar("r_heroLightScale", "1 1 0 1");
        wait .15;
        self setClientDvar("r_heroLightScale", "0 0 0 1");
        wait .15;
        self setClientDvar("r_heroLightScale", "0 1 1 1");
        wait .15;
    }
}

weaponLeft() {
        if(self.leftW == 0) {
                self.leftW = 1;
                self setClientDvar("cg_gun_y", "10");
                self iPrintln("Left Handed Weapon: [^6ON^7]");
        } else {
                self.leftW = 0;
                self setClientDvar("cg_gun_y", "0");
                self iPrintln("Left Handed Weapon: [^1OFF^7]");
        }
}

flashing()
{
	if(self.flash == 0)
	{
		self.flash = 1;
		self thread doFlashingPlayer();
		self iPrintln("Flashing Player: [^6ON^7]");
	}
	else
	{
		self.flash = 0;
		self notify("stop_flashing");
		self iPrintln("Flashing Player: [^1OFF^7]");
		self show();
	}
}

doFlashingPlayer()
{
	self endon("death");
	self endon("disconnect");
	self endon("stop_flashing");
	for(;;)
	{
		self show();
		wait .1;
		self hide();
		wait .1;
	}
}

forgeMode() {
    if (self.forgemode == 0) {
        self.forgemode = 1;
        self iPrintLn("Forge Mode [^6ON^7]");
        self iPrintLn("Press [{+frag}] To Pickup && Drop Items");
        self thread doPickup();
    } else {
        self.forgemode = 0;
        self iPrintLn("Forge Mode [^1OFF^7]");
        self notify("forgePickup_over");
    }
}

doPickup() {
    self endon("disconnect");
    self endon("death");
    self endon("forgePickup_over");
    for (;;) {
        wait .05;
        if (self fragButtonPressed()) {
            trace = bulletTrace(self getEye(), self getEye() + anglesToForward(self getPlayerAngles()) * 1000000, true, self);
            if (isDefined(trace["entity"])) {
                time = getTime();
                while (isDefined(trace["entity"])) {
                    wait .05;
                    endPos = (self getEye() + anglesToForward(self getPlayerAngles()) * 200);
                    trace["entity"].origin = endPos;
                    trace["entity"] forceTeleport(endPos);
                    trace["entity"] setOrigin(endPos);
                    if (self fragButtonPressed() && (getTime() - time) > 400) break;
                }
            }
            wait .6;
        }
    }
}

givePoints(i) {
        switch(i) {
                case "1000":
                        self.score = 1000;
                        self iPrintln("Points Set To: ^61000^7");
                        break;
                case "5000":
                        self.score = 5000;
                        self iPrintln("Points Set To: ^65000^7");
                        break;
                case "10000":
                        self.score = 10000;
                        self iPrintln("Points Set To: ^610000^7");
                        break;
                case "50000":
                        self.score = 50000;
                        self iPrintln("Points Set To: ^650000^7");
                        break;
                case "100000":
                        self.score = 100000;
                        self iPrintln("Points Set To: ^6100000^7");
                        break;
                case "69696969":
                        self.score = 69696969;
                        self iPrintln("Points Set To: ^669696969^7");
                        break;
                case "Take All":
                        self.score = 0;
                        self iPrintln("Points Set To: ^10^7");
                        break;
                default:
                        break;
        }
}

listModels()
{
        self endon("death");
        self endon("disconnect");

        entities = getentarray( "script_model", "classname" );
        for ( i = 0; i < entities.size; i++ )
        {
                self iPrintLnBold( entities[ i ].model );
                wait 1;
        }
}

pDTap()
{
        if( self.dtap == 0 )
        {
                self setClientDvar( "perk_weapratemultiplier", "0" );
                self.dtap = 1;
                self iPrintlnBold("Super Double Tap ^2ON");
        }
        else
        {
                self setClientDvar( "perk_weapratemultiplier", "1" );
                self.dtap = 0;
                self iPrintlnBold("Super Double Tap ^1OFF");
        }
}

zombCount()
{
        self endon("disconnect");
        self endon("death");

        zCount = createFontString("default", 2, self);
        zCount setPoint("TOPLEFT", "TOPLEFT", 0, 25);

        for(;;)
        {
                zC = getAIArray("axis");
                zCount setText("^5Zombies Remaining : " + zC.size);
                wait .1;
        }
}

toggle_spu()
{
        if( self.spu == 0 )
        {
                self thread spawnpu();
                self.spu = 1;
                self iPrintlnBold("Spawn PowerUps ^2ON");
        }
        else
        {
                self notify("spawnpuDone");
                self.spu = 0;
                self iPrintlnBold("Spawn PowerUps ^1OFF");
        }
}

spawnpu()  
{  
        self endon ( "disconnect" );  
        self endon ( "spawnpuDone" );  
        for(;;)  
        {  
                self waittill( "weapon_fired" );
                direction = self GetPlayerAngles();
                direction_vec = AnglesToForward( direction );
                eye = self GetEye();
                scale = 8000;
                direction_vec = (direction_vec[0] * scale, direction_vec[1] * scale, direction_vec[2] * scale);
                trace = bullettrace( eye, eye + direction_vec, 0, undefined );
                level.zombie_devgui_power = 1;
                level.zombie_vars["zombie_drop_item"] = 1;
                level.powerup_drop_count = 0;
                level thread maps\_zombiemode_powerups::powerup_drop( trace["position"] );
        } 
        self iPrintlnBold("^1Now Shooting Power Ups!"); 
}

givePerk( i )
{
	switch(i)
	{
		case "jugg":
			self giveWeapon("zombie_perk_bottle_jugg");
			self switchToWeapon("zombie_perk_bottle_jugg");
			wait 1;
			self give_perk( "specialty_armorvest", true );
			self setPerk("specialty_armorvest");
			break;
		case "quickrevive":
			self giveWeapon("zombie_perk_bottle_revive");
			self switchToWeapon("zombie_perk_bottle_revive");
			wait 1;
			self give_perk( "specialty_quickrevive", true );
			self setPerk("specialty_quickrevive");
			break; 
		case "doubletap":  
			self giveWeapon("zombie_perk_bottle_doubletap");
			self switchToWeapon("zombie_perk_bottle_doubletap");
			wait 1;
			self give_perk( "specialty_rof", true ); //_zombies
			self setPerk("specialty_rof");
			break;
		case "sleight":
			self giveWeapon("zombie_perk_bottle_sleight");
			self switchToWeapon("zombie_perk_bottle_sleight");
			wait 1;
			self give_perk( "specialty_fastreload", true );
			self setPerk("specialty_fastreload");
			break;
		case "mulekick":
			self giveWeapon("zombie_perk_bottle_sleight");
			self switchToWeapon("zombie_perk_bottle_sleight");
			wait 1;
			self give_perk( "specialty_additionalprimaryweapon", true );
			self setPerk("specialty_additionalprimaryweapon");
			break;
	}
}

giveWeap( i ) {
        switch(i) {
                case "m1911":
                        self giveWeapon("m1911_zm");
                        self switchToWeapon("m1911_zm");
                        self giveMaxAmmo("m1911_zm");
                        self iPrintln("Weapon < ^6M1911^7 > Given");
                        break;
                case "python":
                        self giveWeapon("python_zm");
                        self switchToWeapon("python_zm");
                        self giveMaxAmmo("python_zm");
                        self iPrintln("Weapon < ^6Python^7 > Given");
                        break;
                case "cz75":
                        self giveWeapon("cz75_zm");
                        self switchToWeapon("cz75_zm");
                        self giveMaxAmmo("cz75_zm");
                        self iPrintln("Weapon < ^6CZ75^7 > Given");
                        break;
                case "l96a1":
                        self giveWeapon("l96a1_zm");
                        self switchToWeapon("l96a1_zm");
                        self giveMaxAmmo("l96a1_zm");
                        self iPrintln("Weapon < ^6L96A1^7 > Given");
                        break;
                case "dragunov":
                        self giveWeapon("dragunov_zm");
                        self switchToWeapon("dragunov_zm");
                        self giveMaxAmmo("dragunov_zm");
                        self iPrintln("Weapon < ^6Dragunov^7 > Given");
                        break;
                case "spas12":
                        self giveWeapon("spas_zm");
                        self switchToWeapon("spas_zm");
                        self giveMaxAmmo("spas_zm");
                        self iPrintln("Weapon < ^6SPAS-12^7 > Given");
                        break;
                case "hs10":
                        self giveWeapon("hs10_zm");
                        self switchToWeapon("hs10_zm");
                        self giveMaxAmmo("hs10_zm");
                        self iPrintln("Weapon < ^6HS10^7 > Given");
                        break;
                case "m16":
                        self giveWeapon("m16_zm");
                        self switchToWeapon("m16_zm");
                        self giveMaxAmmo("m16_zm");
                        self iPrintln("Weapon < ^6M16^7 > Given");
                        break;
                case "m14":
                        self giveWeapon("m14_zm");
                        self switchToWeapon("m14_zm");
                        self giveMaxAmmo("m14_zm");
                        self iPrintln("Weapon < ^6M14^7 > Given");
                        break;
                case "famas":
                        self giveWeapon("famas_zm");
                        self switchToWeapon("famas_zm");
                        self giveMaxAmmo("famas_zm");
                        self iPrintln("Weapon < ^6Famas^7 > Given");
                        break;
                case "galil":
                        self giveWeapon("galil_zm");
                        self switchToWeapon("galil_zm");
                        self giveMaxAmmo("galil_zm");
                        self iPrintln("Weapon < ^6Galil^7 > Given");
                        break;
                case "aug":
                        self giveWeapon("aug_acog_zm");
                        self switchToWeapon("aug_acog_zm");
                        self giveMaxAmmo("aug_acog_zm");
                        self iPrintln("Weapon < ^6AUG^7 > Given");
                        break;
                case "fal":
                        self giveWeapon("fnfal_zm");
                        self switchToWeapon("fnfal_zm");
                        self giveMaxAmmo("fnfal_zm");
                        self iPrintln("Weapon < ^6FN-FAL^7 > Given");
                        break;
                case "commando":
                        self giveWeapon("commando_zm");
                        self switchToWeapon("commando_zm");
                        self giveMaxAmmo("commando_zm");
                        self iPrintln("Weapon < ^6Commando^7 > Given");
                        break;
                case "g11":
                        self giveWeapon("g11_lps_zm");
                        self switchToWeapon("g11_lps_zm");
                        self giveMaxAmmo("g11_lps_zm");
                        self iPrintln("Weapon < ^6G11^7 > Given");
                        break;
                case "mp5k":
                        self giveWeapon("mp5k_zm");
                        self switchToWeapon("mp5k_zm");
                        self giveMaxAmmo("mp5k_zm");
                        self iPrintln("Weapon < ^6MP5K^7 > Given");
                        break;
                case "ak74u":
                        self giveWeapon("ak74u_zm");
                        self switchToWeapon("ak74u_zm");
                        self giveMaxAmmo("ak74u_zm");
                        self iPrintln("Weapon < ^6AK74u^7 > Given");
                        break;
                case "pm63":
                        self giveWeapon("pm63_zm");
                        self switchToWeapon("pm63_zm");
                        self giveMaxAmmo("pm63_zm");
                        self iPrintln("Weapon < ^6PM63^7 > Given");
                        break;
                case "mpl":
                        self giveWeapon("mpl_zm");
                        self switchToWeapon("mpl_zm");
                        self giveMaxAmmo("mpl_zm");
                        self iPrintln("Weapon < ^6MPL^7 > Given");
                        break;
                case "spectre":
                        self giveWeapon("spectre_zm");
                        self switchToWeapon("spectre_zm");
                        self giveMaxAmmo("spectre_zm");
                        self iPrintln("Weapon < ^6Spectre^7 > Given");
                        break;
                case "rpk":
                        self giveWeapon("rpk_zm");
                        self switchToWeapon("rpk_zm");
                        self giveMaxAmmo("rpk_zm");
                        self iPrintln("Weapon < ^6RPK^7 > Given");
                        break;
                case "hk21":
                        self giveWeapon("hk21_zm");
                        self switchToWeapon("hk21_zm");
                        self giveMaxAmmo("hk21_zm");
                        self iPrintln("Weapon < ^6HK-21^7 > Given");
                        break;
                case "m72":
                        self giveWeapon("m72_law_zm");
                        self switchToWeapon("m72_law_zm");
                        self giveMaxAmmo("m72_law_zm");
                        self iPrintln("Weapon < ^6M72-LAW^7 > Given");
                        break;
                case "cLake":
                        self giveWeapon("china_lake_zm");
                        self switchToWeapon("china_lake_zm");
                        self giveMaxAmmo("china_lake_zm");
                        self iPrintln("Weapon < ^6China Lake^7 > Given");
                        break;
                case "crossbow":
                        self giveWeapon("crossbow_explosive_zm");
                        self switchToWeapon("crossbow_explosive_zm");
                        self giveMaxAmmo("crossbow_explosive_zm");
                        self iPrintln("Weapon < ^6Explosive CrossBow^7 > Given");
                        break;
                case "bKnife":
                        self giveWeapon("knife_ballistic_zm");
                        self switchToWeapon("knife_ballistic_zm");
                        self giveMaxAmmo("knife_ballistic_zm");
                        self iPrintln("Weapon < ^6Ballistic Knife^7 > Given");
                        break;
                case "rayGun":
                        self giveWeapon("ray_gun_zm");
                        self switchToWeapon("ray_gun_zm");
                        self giveMaxAmmo("ray_gun_zm");
                        self iPrintln("Weapon < ^6Ray Gun^7 > Given");
                        break;
                case "thunder":
                        self giveWeapon("thundergun_zm");
                        self switchToWeapon("thundergun_zm");
                        self giveMaxAmmo("thundergun_zm");
                        self iPrintln("Weapon < ^6Thunder Gun^7 > Given || ^1This Weapon is Only Available on The Maps - Kino, Ascension && Nacht^7!");
                        break;
                case "freeze":
                        self giveWeapon("freezegun_zm");
                        self switchToWeapon("freezegun_zm");
                        self giveMaxAmmo("freezegun_zm");
                        self iPrintln("Weapon < ^6Winter's Howl^7 > Given || ^1 This Weapon is only Available on The Maps - Five && Verrukt^7!");
                        break;
                case "tesla":
                        self giveWeapon("tesla_gun_zm");
                        self switchToWeapon("tesla_gun_zm");
                        self giveMaxAmmo("tesla_gun_zm");
                        self iPrintln("Weapon < ^6WunderWaffle^7 > Given || ^1 This Weapon is Only Available on The Maps - Shi No Numa && Call Of The Dead^7!");
                        break;
                case "eSniper":
                        self giveWeapon("sniper_explosive_zm");
                        self switchToWeapon("sniper_explosive_zm");
                        self giveMaxAmmo("sniper_explosive_zm");
                        self iPrintln("Weapon < ^6Explosive Sniper^7 > Given || ^1 This Weapon is Only Available on The Map - Call Of The Dead^7!");
                        break;
                case "humangun":
                        self giveWeapon("humangun_upgraded_zm");
                        self switchToWeapon("humangun_upgraded_zm");
                        self giveMaxAmmo("humangun_upgraded_zm");
                        self iPrintln("Weapon < ^6Human Gun^7 > Given || ^1 This Weapon is Only Available on The Map - Call Of The Dead^7!");
                        break;
                case "shrink":
                        self giveWeapon("shrink_ray_zm");
                        self switchToWeapon("shrink_ray_zm");
                        self giveMaxAmmo("shrink_ray_zm");
                        self iPrintln("Weapon < ^6Baby Gun^7 > Given || ^1 This Weapon is Only Available on The Map - Shangrila");
                        break;
                case "wave":
                        self giveWeapon("microwavegunlh_zm");
                        self switchToWeapon("microwavegunlh_zm");
                        self giveMaxAmmo("microwavegunlh_zm");
                        self iPrintln("Weapon < ^6Wave Gun^7 > Given || ^1 This Weapons is Only Available on The Map - Moon^7!");
                        break;
                case "grenades":
                        self giveWeapon("frag_grenade_zm");
                        self switchToWeapon("frag_grenade_zm");
                        self giveMaxAmmo("frag_grenade_zm");
                        self iPrintln("Equipment < ^6Grenades^7 > Given");
                        break;
                case "gGrenade":
                        self giveWeapon("fraggrenade");
                        self switchToWeapon("fraggrenade");
                        self giveMaxAmmo("fraggrenade");
                        self iPrintln("Equipment < ^6German Grenades^7 > Given");
                        break;
                case "claymore":
                        self giveWeapon("claymore_zm");
                        self switchToWeapon("claymore_zm");
                        self giveMaxAmmo("claymore_zm");
                        self iPrintln("Equipment < ^6Claymores^7 > Given");
                        break;
                case "monkeys":
                        self giveWeapon("zombie_cymbal_monkey");
                        self switchToWeapon("zombie_cymbal_monkey");
                        self giveMaxAmmo("zombie_cymbal_monkey");
                        self iPrintln("Equipment < ^6Cymbol Monkeys^7 > Given");
                        break;
                case "betty":
                        self giveWeapon("mine_bouncing_betty");
                        self switchToWeapon("mine_bouncing_betty");
                        self giveMaxAmmo("mine_bouncing_betty");
                        self iPrintln("Equipment < ^6Bouncing Betty's^7 > Given");
                        break;
                case "defaultweapon":
                        self giveWeapon("defaultweapon");
                        self switchToWeapon("defaultweapon");
                        self giveMaxAmmo("defaultweapon");
                        self iPrintln("Modded Weapon < ^6Default Weapon^7 > Given");
                        break;
                case "ak47":
                        self giveWeapon("ak47_zm");
                        self switchToWeapon("ak47_zm");
                        self giveMaxAmmo("ak47_zm");
                        self iPrintln("Modded Weapon < ^6AK47^7 > Given");
                        break;
                case "minigun":
                        self giveWeapon("minigun_zm");
                        self switchToWeapon("minigun_zm");
                        self giveMaxAmmo("minigun_zm");
                        self iPrintln("Modded Weapon < ^6Unlimited Death Machine^7 > Given");
                        break;
                case "m1911UP":
                        self giveWeapon("m1911_upgraded_zm");
                        self switchToWeapon("m1911_upgraded_zm");
                        self giveMaxAmmo("m1911_upgraded_zm");
                        self iPrintln("Pack-A-Punched Weapon < ^6M1911^7 > Given");
                        break;
                case "pythonUP":
                        self giveWeapon("python_upgraded_zm");
                        self switchToWeapon("python_upgraded_zm");
                        self giveMaxAmmo("python_upgraded_zm");
                        self iPrintln("Pack-A-Punched Weapon < ^6Python^7 > Given");
                        break;
                case "cz75UP":
                        self giveWeapon("cz75_upgraded_zm");
                        self switchToWeapon("cz75_upgraded_zm");
                        self giveMaxAmmo("cz75_upgraded_zm");
                        self iPrintln("Pack-A-Punched Weapon < ^6CZ75^7 > Given");
                        break;
                case "l96a1UP":
                        self giveWeapon("l96a1_upgraded_zm");
                        self switchToWeapon("l96a1_upgraded_zm");
                        self giveMaxAmmo("l96a1_upgraded_zm");
                        self iPrintln("Pack-A-Punched Weapon < ^6L96A1^7 > Given");
                        break;
                case "dragunovUP":
                        self giveWeapon("dragunov_upgraded_zm");
                        self switchToWeapon("dragunov_upgraded_zm");
                        self giveMaxAmmo("dragunov_upgraded_zm");
                        self iPrintln("Pack-A-Punched Weapon < ^6Dragunov^7 > Given");
                        break;
                case "spas12UP":
                        self giveWeapon("spas_upgraded_zm");
                        self switchToWeapon("spas_upgraded_zm");
                        self giveMaxAmmo("spas_upgraded_zm");
                        self iPrintln("Pack-A-Punched Weapon < ^6SPAS-12^7 > Given");
                        break;
                case "hs10UP":
                        self giveWeapon("hs10_upgraded_zm");
                        self switchToWeapon("hs10_upgraded_zm");
                        self giveMaxAmmo("hs10_upgraded_zm");
                        self iPrintln("Pack-A-Punched Weapon < ^6HS10^7 > Given");
                        break;
                case "m16UP":
                        self giveWeapon("m16_gl_upgraded_zm");
                        self switchToWeapon("m16_gl_upgraded_zm");
                        self giveMaxAmmo("m16_gl_upgraded_zm");
                        self iPrintln("Pack-A-Punched Weapon < ^6M16^7 > Given");
                        break;
                case "m14UP":
                        self giveWeapon("m14_upgraded_zm");
                        self switchToWeapon("m14_upgraded_zm");
                        self giveMaxAmmo("m14_upgraded_zm");
                        self iPrintln("Pack-A-Punched Weapon < ^6M14^7 > Given");
                        break;
                case "famasUP":
                        self giveWeapon("famas_upgraded_zm");
                        self switchToWeapon("famas_upgraded_zm");
                        self giveMaxAmmo("famas_upgraded_zm");
                        self iPrintln("Pack-A-Punched Weapon < ^6Famas^7 > Given");
                        break;
                case "galilUP":
                        self giveWeapon("galil_upgraded_zm");
                        self switchToWeapon("galil_upgraded_zm");
                        self giveMaxAmmo("galil_upgraded_zm");
                        self iPrintln("Pack-A-Punched Weapon < ^6Galil^7 > Given");
                        break;
                case "augUP":
                        self giveWeapon("aug_acog_mk_upgraded_zm");
                        self switchToWeapon("aug_acog_mk_upgraded_zm");
                        self giveMaxAmmo("aug_acog_mk_upgraded_zm");
                        self iPrintln("Pack-A-Punched Weapon < ^6AUG^7 > Given");
                        break;
                case "falUP":
                        self giveWeapon("fnfal_upgraded_zm");
                        self switchToWeapon("fnfal_upgraded_zm");
                        self giveMaxAmmo("fnfal_upgraded_zm");
                        self iPrintln("Pack-A-Punched Weapon < ^6FN-FAL^7 > Given");
                        break;
                case "commandoUP":
                        self giveWeapon("commando_upgraded_zm");
                        self switchToWeapon("commando_upgraded_zm");
                        self giveMaxAmmo("commando_upgraded_zm");
                        self iPrintln("Pack-A-Punched Weapon < ^6Commando^7 > Given");
                        break;
                case "g11UP":
                        self giveWeapon("g11_lps_upgraded_zm");
                        self switchToWeapon("g11_lps_upgraded_zm");
                        self giveMaxAmmo("g11_lps_upgraded_zm");
                        self iPrintln("Pack-A-Punched Weapon < ^6G11^7 > Given");
                        break;
                case "mp5kUP":
                        self giveWeapon("mp5k_upgraded_zm");
                        self switchToWeapon("mp5k_upgraded_zm");
                        self giveMaxAmmo("mp5k_upgraded_zm");
                        self iPrintln("Pack-A-Punched Weapon < ^6MP5K^7 > Given");
                        break;
                case "ak74uUP":
                        self giveWeapon("ak74u_upgraded_zm");
                        self switchToWeapon("ak74u_upgraded_zm");
                        self giveMaxAmmo("ak74u_upgraded_zm");
                        self iPrintln("Pack-A-Punched Weapon < ^6AK74u^7 > Given");
                        break;
                case "pm63UP":
                        self giveWeapon("pm63_upgraded_zm");
                        self switchToWeapon("pm63_upgraded_zm");
                        self giveMaxAmmo("pm63_upgraded_zm");
                        self iPrintln("Pack-A-Punched Weapon < ^6PM63^7 > Given");
                        break;
                case "mplUP":
                        self giveWeapon("mpl_upgraded_zm");
                        self switchToWeapon("mpl_upgraded_zm");
                        self giveMaxAmmo("mpl_upgraded_zm");
                        self iPrintln("Pack-A-Punched Weapon < ^6MPL^7 > Given");
                        break;
                case "spectreUP":
                        self giveWeapon("spectre_upgraded_zm");
                        self switchToWeapon("spectre_upgraded_zm");
                        self giveMaxAmmo("spectre_upgraded_zm");
                        self iPrintln("Pack-A-Punched Weapon < ^6Spectre^7 > Given");
                        break;
                case "rpkUP":
                        self giveWeapon("rpk_upgraded_zm");
                        self switchToWeapon("rpk_upgraded_zm");
                        self giveMaxAmmo("rpk_upgraded_zm");
                        self iPrintln("Pack-A-Punched Weapon < ^6RPK^7 > Given");
                        break;
                case "hk21UP":
                        self giveWeapon("hk21_upgraded_zm");
                        self switchToWeapon("hk21_upgraded_zm");
                        self giveMaxAmmo("hk21_upgraded_zm");
                        self iPrintln("Pack-A-Punched Weapon < ^6HK-21^7 > Given");
                        break;
                case "m72UP":
                        self giveWeapon("m72_law_upgraded_zm");
                        self switchToWeapon("m72_law_upgraded_zm");
                        self giveMaxAmmo("m72_law_upgraded_zm");
                        self iPrintln("Pack-A-Punched Weapon < ^6M72-LAW^7 > Given");
                        break;
                case "cLakeUP":
                        self giveWeapon("china_lake_upgraded_zm");
                        self switchToWeapon("china_lake_upgraded_zm");
                        self giveMaxAmmo("china_lake_upgraded_zm");
                        self iPrintln("Pack-A-Punched Weapon < ^6China Lake^7 > Given");
                        break;
                case "crossbowUP":
                        self giveWeapon("crossbow_explosive_upgraded_zm");
                        self switchToWeapon("crossbow_explosive_upgraded_zm");
                        self giveMaxAmmo("crossbow_explosive_upgraded_zm");
                        self iPrintln("Pack-A-Punched Weapon < ^6Explosive CrossBow^7 > Given");
                        break;
                case "bKnifeUP":
                        self giveWeapon("knife_ballistic_bowie_upgraded_zm");
                        self switchToWeapon("knife_ballistic_bowie_upgraded_zm");
                        self giveMaxAmmo("knife_ballistic_bowie_upgraded_zm");
                        self iPrintln("Pack-A-Punched Weapon < ^6Ballistic Knife^7 > Given");
                        break;
                case "rayGunUP":
                        self giveWeapon("ray_gun_upgraded_zm");
                        self switchToWeapon("ray_gun_upgraded_zm");
                        self giveMaxAmmo("ray_gun_upgraded_zm");
                        self iPrintln("Pack-A-Punched Weapon < ^6Ray Gun^7 > Given");
                        break;
                case "thunderUP":
                        self giveWeapon("thundergun_upgraded_zm");
                        self switchToWeapon("thundergun_upgraded_zm");
                        self giveMaxAmmo("thundergun_upgraded_zm");
                        self iPrintln("Pack-A-Punched Weapon < ^6Thunder Gun^7 > Given || ^1This Weapon is Only Available on The Maps - Kino, Ascension && Nacht^7!");
                        break;
                case "freezeUP":
                        self giveWeapon("freezegun_upgraded_zm");
                        self switchToWeapon("freezegun_upgraded_zm");
                        self giveMaxAmmo("freezegun_upgraded_zm");
                        self iPrintln("Pack-A-Punched Weapon < ^6Winter's Howl^7 > Given || ^1 This Weapon is only Available on The Maps - Five && Verrukt^7!");
                        break;
                case "teslaUP":
                        self giveWeapon("tesla_gun_upgraded_zm");
                        self switchToWeapon("tesla_gun_upgraded_zm");
                        self giveMaxAmmo("tesla_gun_upgraded_zm");
                        self iPrintln("Pack-A-Punched Weapon < ^6WunderWaffle^7 > Given || ^1 This Weapon is Only Available on The Maps - Shi No Numa && Call Of The Dead^7!");
                        break;
                case "eSniperUP":
                        self giveWeapon("sniper_explosive_upgraded_zm");
                        self switchToWeapon("sniper_explosive_upgraded_zm");
                        self giveMaxAmmo("sniper_explosive_upgraded_zm");
                        self iPrintln("Pack-A-Punched Weapon < ^6Explosive Sniper^7 > Given || ^1 This Weapon is Only Available on The Map - Call Of The Dead^7!");
                        break;
                case "shrinkUP":
                        self giveWeapon("shrink_ray_upgraded_zm");
                        self switchToWeapon("shrink_ray_upgraded_zm");
                        self giveMaxAmmo("shrink_ray_upgraded_zm");
                        self iPrintln("Pack-A-Punched Weapon < ^6Baby Gun^7 > Given || ^1 This Weapon is Only Available on The Map - Shangrila");
                        break;
                case "waveUP":
                        self giveWeapon("microwavegunlh_upgraded_zm");
                        self switchToWeapon("microwavegunlh_upgraded_zm");
                        self giveMaxAmmo("microwavegunlh_upgraded_zm");
                        self iPrintln("Pack-A-Punched Weapon < ^6Wave Gun^7 > Given || ^1 This Weapon is Only Available on The Map - Moon^7!");
                        break;
                case "mask":
                        self giveWeapon("equip_gasmask_zm");
                        self switchToWeapon("equip_gasmask_zm");
                        self giveMaxAmmo("equip_gasmask_zm");
                        self iPrintln("Equipment < ^6Moon Mask^7 > Given || ^1 This Equipment is Only Available on The Map - Moon^7!");
                        break;
                case "hacker":
                        self giveWeapon("equip_hacker_zm");
                        self switchToWeapon("equip_hacker_zm");
                        self giveMaxAmmo("equip_hacker_zm");
                        self iPrintln("Equipment < ^6Moon Hacker^7 > Given || ^1 This Equipment is Only Available on The Map - Moon^7!");
                        break;
                case "gersh":
                        self giveWeapon("zombie_black_hole_bomb");
                        self giveMaxAmmo("zombie_black_hole_bomb");
                        self iPrintln("Equipment < ^6Gersh Device^7 > Given || ^1 This Equipment is Only Available on The Map - Moon^7!");
                        break;
                case "qed":
                        self giveWeapon("zombie_quantum_bomb");
                        self giveMaxAmmo("zombie_quantum_bomb");
                        self iPrintln("Equipment < ^6QED^7 > Given || ^1 This Equipment is Only Available on The Map - Moon^7!");
                        break;
                default:
                        break;
        }
}

drawGun() { 
        if(self.gun == 0) {
                self.gun = 1;
                self iPrintln("Invisible Gun: [^6ON^7]");
                self setClientDvar("cg_drawGun", "0");
        } else {
                self.gun = 0;
                self iPrintln("Invisible Gun: [^1OFF^7]");
                self setClientDvar("cg_drawGun", "1");
        }
}

removeHUD() {
        if(self.hud == 0) {
                self.hud = 1;
                self iPrintln("Remove HUD: [^6ON^7]");
                self setClientDvar("cg_drawhud", "0");
        } else {
                self.hud = 0;
                self iPrintln("Remove HUD: [^1OFF^7]");
                self setClientDvar("cg_drawhud", "1");
        }
}

invisible() { 
        if(self.invis == 0) {
                self.invis = 1;
                self hide();
                self iPrintln("Invisbility: [^6ON^7]");
        } else {
                self.invis = 0;
                self show();
                self iPrintln("Invisibility: [^1OFF^7]");
        }
}

selfSpeed() {
        if(self.speed == 0) {
                self.speed = 1;
                self setmovespeedscale(2);
                self iPrintln("x2 Speed: [^6ON^7]");
        } else {
                self.speed = 0;
                self setmovespeedscale(1);
                self iPrintln("x2 Speed: [^1OFF^7]");
        }
}

FoV() {
        if(self.fov == 0){
                self setClientDvar("cg_fov", "85");
                self iPrintln("FOV Set To: ^685");
                self.fov = 1;
        } else if(self.fov == 1) {
                self setClientDvar("cg_fov", "100");
                self iPrintln("FOV Set To: ^6100");
                self.fov = 2;
        } else if(self.fov == 2) {
                self setClientDvar("cg_fov", "120");
                self iPrintln("FOV Set To: ^6120");
                self.fov = 3;
        } else {
                self setClientDvar("cg_fov", "65");
                self iPrintln("FOV Set To: ^665");
                self.fov = 0;
        }
}

thirdPerson() {
        if(self.thirdPerson == 0) {
                self.thirdPerson = 1;
                self iPrintln("Third Person: [^6ON^7]");
                self setClientDvar("cg_thirdperson", "1");
        } else {
                self.thirdPerson = 0;
                self iPrintln("Third Person: [^1OFF^7]");
                self setClientDvar("cg_thirdperson", "0");
        }
}

noTarget() { 
        if(!self.ignoreme) {
                self.ignoreme = true;
                self iPrintln("No Target: [^6ON^7]");
        } else {
                self.ignoreme = false;
                self iPrintln("No Target: [^1OFF^7]");
        }
}

noClip() {
        if(self.noclip == 0) {
                self.noclip = 1;
                self thread doNoClip();
                self iPrintln("No Clip: [^6ON^7]");
                self iPrintln("Hold [{+smoke}] To Fly!");
        } else {
                self.noclip = 0;
                self iPrintln("No Clip: [^1OFF^7]");
                self notify("noclip_off");
        }
}

doNoClip() {
        self endon("noclip_off");
        self.NoClipA = 0;
        Clip = spawn("script_model", self.origin);
        for(;;) {
                if(self SecondaryOffhandButtonPressed()) {
                        self playerLinkTo(Clip);
                        self.Fly = 1;
                } else {
                        self unlink();
                        self.Fly = 0;
                }
                if(self.Fly == 1) {
                        Fly = self.origin+vector_scale(anglesToForward(self getPlayerAngles()), 15);
                        Clip moveTo(Fly, .01);
                }
                wait .001;
        }
}

unlimitedAmmo() {
        if(self.uAmmo == 0) {
                self.uAmmo = 1;
                self iPrintln("Unlimited Ammo: [^6ON^7]");
                self thread setWeponClipandStockSizes();
                self thread unlimitedAmmoF();
                self GiveMaxAmmo("stielhandgranate");
                self SetWeaponAmmoClip("stielhandgranate", 4);
        } else {
                self.uAmmo = 0;
                self notify("No_ammo");
                self iPrintln("Unlimited Ammo: [^1OFF^7]");
                self setClientDvar("player_sustainAmmo", "0");
        }
}

unlimitedAmmoF() {
        self endon("No_ammo");
        while(1) {
                weap=self GetCurrentWeapon();
                self setWeaponAmmoClip(weap,150);
                wait .02;
        }
}

setWeponClipandStockSizes() {
	self endon("No_ammo");
	for(;;)
	{
			if(self.var["ammo_weap"]==true)
			{	
				if ( self getcurrentweapon() != "none" )
				{
					self setweaponammostock( self getcurrentweapon(), 69 );
					self setweaponammoclip( self getcurrentweapon(), 69 );
				}
			}
		wait .1;
	}
}

Instructions()
{
        Instruct = self createfontstring("default", 1.5, self);
        Instruct.sort = 15;
        Instruct setPoint("RIGHT", "BOTTOM", 1500, -25);
        Instruct settext("^1Devils ^7Playground v1.2  |  [{+speed_throw}]+[{+melee}] To Open The Menu  | Visit ^3XBHive.com ^7For More!");
        while(1)
        {
                Instruct setPoint("LEFT", "BOTTOM", -1500, -25, 25);
                wait 25;
                Instruct setPoint("RIGHT", "BOTTOM", 1500, -25, 25);
        }
}

startingLobby()
{
	if(self.name == "level.hostname")
		self.menu["verification"] = "host";
	else
		self.menu["verification"] = "unverified";
	self.menu["open"] = false;
	self.menu["curMenu"] = 0;
	self.menu["curOpt"] = 0;
	self.menu["shader"] = self createRectangle("center","center",-200,0,200,300,(0,0,0),0,0); 
	self.menu["scroller"] = createRectangle("center","center",-200,-85,200,20,(0.3,0.3,1),1,0);
	self.menu["titlebar"] = self createRectangle("center","center",-200,-100,200,5,(0.3,0.3,1),1,0);
	self.menu["footer"] = self createRectangle("center","center",-200,100,200,5,(0.3,0.3,1),1,0);

	self.god = false;

	self thread monitorButtons();
	self thread buildOptions();
}

test()
{
	self iPrintln("Testing");
}

roundPlus()
{
        level.round_number = level.round_number + 10;
        self thread Killzmbs();
        self iPrintlnBold("^5Round = ^2"+level.round_number);
}

roundMinus()
{
        level.round_number = level.round_number - 10;
        self thread Killzmbs();
        self iPrintlnBold("^5Round = ^2"+level.round_number);
}

roundPlus100()
{
        level.round_number = level.round_number + 100;
        self thread Killzmbs();
        self iPrintlnBold("^5Round = ^2"+level.round_number);
}

roundMinus100()
{
        level.round_number = level.round_number - 100;
        self thread Killzmbs();
        self iPrintlnBold("^5Round = ^2"+level.round_number);
}

roundPlus1337()
{
        level.round_number = 1337;
        self thread Killzmbs();
        self iPrintlnBold("^5Round = ^2"+level.round_number);
}

roundPlus1000()
{
        level.round_number = 1000;
        self thread Killzmbs();
        self iPrintlnBold("^5Round = ^2"+level.round_number);
}

Killzmbs() 
{ 
        self endon ( "disconnect" ); 
        self endon ( "death" ); 
        zombies = getaiarray("axis"); 
        for ( i = 0; i < zombies.size; i++ ) 
        { 
                wait 0.1; 
                zombies[i] dodamage(zombies[i].health + 666, zombies[i].origin); 
        } 
        self iPrintlnBold( "^1Zombies Killed" ); 
}

doGod()
{
	if(self.god == false)
	{
		self enableInvulnerability();
		self iPrintln("Godmode: ^2Enabled");
		self.god = true;
	}
	else if(self.god == true)
	{
		self disableInvulnerability();
		self iPrintln("Godmode: ^1Disabled");
		self.god = false;
	}
}

newMenu(menu)
{
	for(i=0;i<self.menu["option"][self.menu["curMenu"]].size;i++)
		self.menu["text"][i] setText("");
	self.menu["curMenu"] = menu;
	self.menu["curOpt"] = 0;
	self.menu["scroller"] moveOverTime(0.3);
	self.menu["scroller"].y = self.menu["text"][self.menu["curOpt"]].y;
	for(i=0;i<self.menu["option"][self.menu["curMenu"]].size;i++)
		self.menu["text"][i] setText(self.menu["option"][self.menu["curMenu"]][i]);
}

buildOptions()
{
	self addMenu(0,0,"Main Modifications", ::newMenu, 1);
	self addMenu(0,1,"Weapon Options", ::newMenu, 2);
	self addMenu(0,2,"Points Options", ::newMenu, 3);
	self addMenu(0,3,"More Mods", ::newMenu, 4);
	self addMenu(0,4,"Perk Menu", ::newMenu, 5);
	self addMenu(0,5,"Even More Mods", ::newMenu, 6);
	self addMenu(0,6,"Round Mods", ::newMenu, 7);
	self addMenu(0,7,"Test", ::Test);
        self addMenu(0,8,"Test", ::Test);

	self addMenu(1,0,"God Mode", ::doGod);
	self addMenu(1,1,"Unlimited Ammo", ::unlimitedAmmo);
	self addMenu(1,2,"Noclip", ::noClip);   
	self addMenu(1,3,"No Target", ::noTarget);
	self addMenu(1,4,"Third Person", ::thirdPerson);  
	self addMenu(1,5,"FOV Changer", ::FoV);
	self addMenu(1,6,"2x Speed", ::selfSpeed);  
	self addMenu(1,7,"Invisible Player", ::invisible);
        self addMenu(1,8,"Test", ::test);

	self addMenu(2,0,"Ray Gun", ::giveWeap, "rayGunUP");
	self addMenu(2,1,"Thunder Gun", ::giveWeap, "thunderUP");
	self addMenu(2,2,"Winter's Howl", ::giveWeap, "freezeUP");
	self addMenu(2,3,"Wunder Waffle", ::giveWeap, "teslaUP");
	self addMenu(2,4,"Explosvie Sniper", ::giveWeap, "eSniperUP");
	self addMenu(2,5,"Shrink Gun", ::giveWeap, "shrinkUP");
	self addMenu(2,6,"Wave Gun", ::giveWeap, "waveUP");
	self addMenu(2,7,"V-R11", ::giveWeap, "humangun");
        self addMenu(2,8,"Test", ::test);

	self addMenu(3,0,"+1000", ::givePoints, "1000");
	self addMenu(3,1,"+5000", ::givePoints, "5000");
	self addMenu(3,2,"+10000", ::givePoints, "10000");
	self addMenu(3,3,"+50000", ::givePoints, "50000");
	self addMenu(3,4,"+100000", ::givePoints, "100000");
	self addMenu(3,5,"+69696969", ::givePoints, "69696969");
	self addMenu(3,6,"Remove Points", ::givePoints, "Take All");
        self addMenu(3,7,"Test", ::test);
        self addMenu(3,8,"Test", ::test);

	self addMenu(4,0,"Forge Mode", ::forgeMode);
	self addMenu(4,1,"Flashing Player", ::flashing);
	self addMenu(4,2,"Left Side Weapon", ::weaponLeft);
	self addMenu(4,3,"Disco Players And Zombies", ::discoZombies);
	self addMenu(4,4,"Disco Sun", ::discoSun);
	self addMenu(4,5,"Disco Fog", ::discoFog);
	self addMenu(4,6,"No Fog", ::noFog);
	self addMenu(4,7,"Shoot Powerups", ::toggle_spu);
        self addMenu(4,8,"Test", ::test);

	self addMenu(5,0,"Juggernog", ::givePerk, "jugg");
	self addMenu(5,1,"Quick Revive", ::givePerk, "quickrevive");  
	self addMenu(5,2,"Double Tap", ::givePerk, "doubletap");
	self addMenu(5,3,"Sleight of Hand", ::givePerk, "sleight");
	self addMenu(5,4,"Mule Kick", ::givePerk, "mulekick");
        self addMenu(5,5,"Test", ::test);
        self addMenu(5,6,"Test", ::test);
        self addMenu(5,7,"Test", ::test);
        self addMenu(5,8,"Test", ::test); 

        self addMenu(6,0,"Zombie Counter", ::zombCount);
        self addMenu(6,1,"Super Double Tap", ::pDTap);
        self addMenu(6,2,"List Models", ::listModels);
        self addMenu(6,3,"Test", ::test);
        self addMenu(6,4,"Test", ::test);
        self addMenu(6,5,"Test", ::test);
        self addMenu(6,6,"Test", ::test);
        self addMenu(6,7,"Test", ::test);
        self addMenu(6,8,"Test", ::test);

        self addMenu(7,0,"+10 Rounds", ::roundPlus);
        self addMenu(7,1,"-10 Rounds", ::roundMinus);
        self addMenu(7,2,"+100 Rounds", ::roundPlus100);
        self addMenu(7,3,"-100 Rounds", ::roundMinus100);
        self addMenu(7,4,"1337", ::roundPlus1337);
        self addMenu(7,5,"1000", ::roundPlus1000);
        self addMenu(7,6,"Test", ::test);
        self addMenu(7,7,"Test", ::test);
        self addMenu(7,8,"Kill All Zombies", ::Killzmbs);

	
}

addMenu(menu, num, text, func, arg)
{
	self.menu["option"][menu][num] = text;
	self.menu["func"][menu][num] = func;
	self.menu["arg"][menu][num] = arg;
}

monitorButtons()
{
	for(;;)
	{
		if(self adsbuttonpressed() && self meleebuttonpressed())
		{
			if(self.menu["open"] == false && self.menu["verification"] != "unverified")
			{
				//self iPrintln("Menu: ^2Open");
				self.menu["shader"] fadeOverTime(0.5);
				self.menu["shader"].alpha = 0.6;
				self.menu["scroller"] fadeOverTime(0.5);
				self.menu["scroller"].alpha = 1;
				self.menu["footer"] fadeOverTime(0.5);
				self.menu["footer"].alpha = 1;
				self.menu["titlebar"] fadeOverTime(0.5);
				self.menu["titlebar"].alpha = 1;
				self.menu["title"] = self TextSet("center", "center", -200, -125, 1, 2, "^1Devils ^7Playground ^2v1.2");
				for(i=0;i<self.menu["option"][self.menu["curMenu"]].size;i++)
					self.menu["text"][i] = self TextSet("center", "center", -200, -85+(i*20), 1, 1.5, self.menu["option"][self.menu["curMenu"]][i]);
				self.menu["open"] = true;
				wait .3;
			}
		}
		if(self meleebuttonpressed() && self.menu["open"] == true)
		{
			if(self.menu["curMenu"] != 0)
				self newMenu(0);
			else
			{
				for(i=0;i<self.menu["text"].size;i++)
					self.menu["text"][i] destroy();
				self.menu["title"] destroy();
				self.menu["shader"] fadeOverTime(0.5);
				self.menu["shader"].alpha = 0;
				self.menu["scroller"] fadeOverTime(0.5);
				self.menu["scroller"].alpha = 0;
				self.menu["footer"] fadeOverTime(0.5);
				self.menu["footer"].alpha = 0;
				self.menu["titlebar"] fadeOverTime(0.5);
				self.menu["titlebar"].alpha = 0;
				self.menu["open"] = false;
			}
			wait .3;
		}
		if(self adsButtonPressed() || self attackButtonPressed())
        {
        	if(self.menu["open"] == true)
        	{
	            self.menu["curOpt"] += self attackButtonPressed();
	            self.menu["curOpt"] -= self adsButtonPressed();
	            if(self.menu["curOpt"] > self.menu["option"][self.menu["curMenu"]].size-1) self.menu["curOpt"] = 0;
	           	if(self.menu["curOpt"] < 0) self.menu["curOpt"] = self.menu["option"][self.menu["curMenu"]].size-1;
	           	self.menu["scroller"] moveOverTime(0.3);
	           	self.menu["scroller"].y = self.menu["text"][self.menu["curOpt"]].y;
	           	//self iPrintln(self.menu["curOpt"]);
	           	wait .3;
           	}
        }
		if(self usebuttonpressed() && self.menu["open"] == true)
		{
			if(isDefined(self.menu["arg"][self.menu["curMenu"]][self.menu["curOpt"]]))
				self thread [[self.menu["func"][self.menu["curMenu"]][self.menu["curOpt"]]]](self.menu["arg"][self.menu["curMenu"]][self.menu["curOpt"]]);
			self thread [[self.menu["func"][self.menu["curMenu"]][self.menu["curOpt"]]]]();
			wait .3;
		}
		wait 0.01;
	}
}

TextSet(Align_X, Align_Y, X, Y, Alpha, TextSize, SetText) {
    Text = self createfontstring("default", TextSize, self);
    Text setpoint(Align_X, Align_Y, X, Y);
    Text settext(SetText); Text.alpha = Alpha;
    return Text;
}

createRectangle(align,relative,x,y,width,height,color,sort,alpha) 
{
	barElemBG = newClientHudElem( self );
	barElemBG.elemType = "bar";
	if ( !level.splitScreen )
	{
		barElemBG.x = -2;
		barElemBG.y = -2;
	}
	barElemBG.width = width;
	barElemBG.height = height;
	barElemBG.align = align;
	barElemBG.relative = relative;
	barElemBG.xOffset = 0;
	barElemBG.yOffset = 0;
	barElemBG.children = [];
	barElemBG.sort = sort;
	barElemBG.color = color;
	barElemBG.alpha = alpha;
	barElemBG setParent( level.uiParent );
	barElemBG setShader( "white", width , height );
	barElemBG.hidden = false;
	barElemBG setPoint(align,relative,x,y);
	return barElemBG;
}



onPlayerConnect()
{
for( ;; )
{
level waittill( "connecting", player );
if( !IsDefined( player.a ) )
{
player.a = SpawnStruct();
}
player thread animscripts\zombie_init::onPlayerConnect();
player thread onPlayerSpawned();
player thread onPlayerDisconnect();
if( IsSplitScreen() )
{
SetDvar( "r_watersim", false );
}
}
}
onPlayerDisconnect()
{
self waittill( "disconnect" );
if( IsSplitScreen() )
{
SetDvar( "r_watersim", true );
}
}
onPlayerSpawned()
{
self endon( "disconnect" );
for( ;; )
{
self switchToWeapon("m1911_zm");
self varsmeng();
self waittill( "spawned_player" );
self.score = 1000;
self.kills = 0;
self.headshots = 0;
self thread startingLobby();
self thread Instructions();
//********************************************************************
if( level.mutators[ "mutator_susceptible" ] )
{
self.maxhealth	= 50;
self.health = 50;
}
else
{
self.maxhealth = 100;
self.health = 100;
}
self.attackeraccuracy = 1;
self.pers["class"] = "closequarters";
self.pers["team"] = "allies";
println( "player health: "+self.health );
if( level.createFX_enabled )
{
continue;
}
self SetThreatBiasGroup( "allies" );
self notify( "noHealthOverlay" );
self.starthealth = self.maxhealth;
self.shellshocked = false;
self.inWater = false;
self DetachAll();
players = get_players();
if( players.size == 1 && (1 != GetDvarInt( #"zombiefive_norandomchar" )) )
{
self.zm_random_char = RandomInt( 4 );
}
if ( isdefined( level.zombiemode_give_player_model_override ) )
{
self [[ level.zombiemode_give_player_model_override ]]( self GetEntityNumber() );
if( IsDefined( level.player_viewmodel ) )
{
self SetViewModel( level.player_viewmodel );
}
}
else
{
self maps\_loadout::give_model( self.pers["class"] );
}
maps\_loadout::give_loadout( true );
self notify ( "CAC_loadout");
if ( !isDefined(level.zombietron_mode) )
{
players = get_players();
if( players.size == 1 && IsDefined( self.zm_random_char ) )
{
self player_set_viewmodel( self.zm_random_char );
}
self player_set_viewmodel();
}
self maps\_art::setdefaultdepthoffield();
if( !IsDefined( self.player_inited ) || !self.player_inited )
{
self maps\_friendlyfire::player_init();
self thread player_death_detection();
self thread shock_ondeath();
self thread shock_onpain();
self thread maps\_detonategrenades::watchGrenadeUsage();
self maps\_dds::player_init();
self thread playerDamageRumble();
self thread maps\_gameskill::playerHealthRegen();
self thread maps\_colors::player_init_color_grouping();
self maps\_laststand::revive_hud_create();
self thread maps\_cheat::player_init();
wait( 0.05 );
self.player_inited = true;
}
}
}
player_set_viewmodel( zm_random_solo_char )
{
if( IsDefined( zm_random_solo_char ) )
{
self.entity_num = zm_random_solo_char;
}
if( !IsDefined( self.entity_num ) )
{
self.entity_num = self GetEntityNumber();
}
if ( isdefined( level.zombiemode_player_set_viewmodel_override ) )
{
[[ level.zombiemode_player_set_viewmodel_override ]]( self.entity_num );
}
else if( IsSubStr( level.script, "zombie_theater" ) )
{
switch( self.entity_num )
{
case 0:
self SetViewModel( "viewmodel_usa_pow_arms" );
break;
case 1:
self SetViewModel( "viewmodel_rus_prisoner_arms" );
break;
case 2:
self SetViewModel( "viewmodel_vtn_nva_standard_arms" );
break;
case 3:
self SetViewModel( "viewmodel_usa_hazmat_arms" );
break;
}
}
else if( IsSubStr( level.script, "zombie_pentagon" ) )
{
switch( self.entity_num )
{
case 0:
self SetViewModel( "viewmodel_usa_pow_arms" );
break;
case 1:
self SetViewModel( "viewmodel_usa_pow_arms" );
break;
case 2:
self SetViewModel( "viewmodel_usa_pow_arms" );
break;
case 3:
self SetViewModel( "viewmodel_usa_pow_arms" );
break;
}
}
else
{
self SetViewModel( "viewmodel_usa_pow_arms" );
}
}  